# Rimay: Quantum Feature Extraction

Classify heart disease using quantum-encoded features from [Rimay](https://hub.kipu-quantum.com/) on Kipu Quantum Hub.

## Setup

```bash
# Install dependencies
uv sync

# Configure credentials
cp .env.example .env
# Edit .env with your Kipu credentials
```

## Run

Open `Rimay-Hello-World.ipynb` in Jupyter and run all cells.

## What it does

1. Loads the Heart Disease dataset (270 samples, 13 clinical features)
2. Submits to Rimay for quantum feature extraction on `ibm_aer` simulator
3. Compares classical vs quantum features using Gradient Boosting classification
4. Visualizes how quantum encoding transforms the feature correlation structure

## Requirements

- Python 3.12+
- Rimay service credentials (request access at [hub.kipu-quantum.com](https://hub.kipu-quantum.com/))
- PlanQK Access token (found at: https://dashboard.hub.kipu-quantum.com/home)

## Reference

[Digitized Counterdiabatic Quantum Feature Extraction (arXiv:2510.13807)](https://arxiv.org/abs/2510.13807)
